<?php
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class BuonoSconto {
        private $db;
        private $id;
        private $nome;
        private $codice;
        private $tipo;
        private $ammontare;
        private $buoniRimanenti;
        private $spesaMinima;
        private $limitePerPersona;
        private $prodottiInteressati;
        private $prodotto;
        private $categoria;
        private $dataScadenza;
        
        public function __construct($db, $id, $nome="", $codice="", $tipo="", $ammontare=0, $buoniRimanenti="", $limitePerPersona =0,$spesaMinima=0, $prodottiInteressati="", $dataScadenza="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome           = $nome;
            $this->codice         = $codice;
            $this->tipo           = $tipo;
            $this->ammontare      = $ammontare;
            $this->buoniRimanenti = $buoniRimanenti;
            $this->spesaMinima    = $spesaMinima;
            $this->limitePerPersona    = $limitePerPersona;
            $this->prodottiInteressati = $prodottiInteressati;
            $this->dataScadenza        = $dataScadenza;
        }

        public function crea() {
            $dataCreazione = date("Y-m-d");
            $query = "INSERT INTO `geecEc_buoniSconto` (`id`, `nome`, `codice`, `tipo`, `ammontareSconto`, `prodottiInteressati`, `prodotto`, `categoria`, `spesaMinima`, `limitePerPersona`, `buoniRimanenti`, `dataCreazione`, `dataScadenza`) 
                        VALUES (NULL, '$this->nome', '$this->codice', '$this->tipo', '$this->ammontare', '$this->prodottiInteressati', '$this->prodotto', '$this->categoria', '$this->spesaMinima', '$this->limitePerPersona', '$this->buoniRimanenti', '$this->dataScadenza', '$dataCreazione');";
            return $this->db->eseguiQueryCreazione($query);
        }
        
        public function modifica() {
            $query = "UPDATE geecEc_buoniSconto SET nome='$this->nome', codice='$this->codice', tipo='$this->tipo', ammontareSconto='$this->ammontare', prodottiInteressati='$this->prodottiInteressati', prodotto='$this->prodotto', categoria='$this->categoria', spesaMinima='$this->spesaMinima', limitePerPersona='$this->limitePerPersona', buoniRimanenti='$this->buoniRimanenti', dataScadenza='$this->dataScadenza' WHERE id=$this->id";
            $this->db->eseguiQueryLettura($query);
        }
        
        public function elimina() {
            $this->db->eseguiQueryCancellazione("geecEc_buoniSconto",$this->id);
        }
        
        public function caricaDatiDalDatabase() {
            $datiBuonoSconto = $this->db->leggiSingolaRiga("geecEc_buoniSconto",$this->id);
            $this->nome           = $datiBuonoSconto["nome"];
            $this->codice         = $datiBuonoSconto["codice"];
            $this->tipo           = $datiBuonoSconto["tipo"];
            $this->ammontare      = $datiBuonoSconto["ammontareSconto"];
            $this->buoniRimanenti = $datiBuonoSconto["buoniRimanenti"];
            $this->prodotto       = $datiBuonoSconto["prodotto"];
            $this->categoria      = $datiBuonoSconto["categoria"];
            $this->spesaMinima    = $datiBuonoSconto["spesaMinima"];
            $this->limitePerPersona    = $datiBuonoSconto["limitePerPersona"];
            $this->prodottiInteressati = $datiBuonoSconto["prodottiInteressati"];
            $this->dataScadenza        = $datiBuonoSconto["dataScadenza"];
        }
        
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getCodice() {
            return $this->codice;
        }

        public function getTipo() {
            return $this->tipo;
        }

        public function getAmmontare() {
            return $this->ammontare;
        }

        public function getBuoniRimanenti() {
            return $this->buoniRimanenti;
        }

        public function getSpesaMinima() {
            return $this->spesaMinima;
        }
        
        public function getLimitePerPersona() {
            return $this->limitePerPersona;
        }

        public function getProdottiInteressati() {
            return $this->prodottiInteressati;
        }

        public function getProdotto() {
            return $this->prodotto;
        }

        public function getCategoria() {
            return $this->categoria;
        }

        public function getDataScadenza() {
            return $this->dataScadenza;
        }
        
        public function setDb($db): void {
            $this->db = $db;
        }

        public function setId($id): void {
            $this->id = $id;
        }

        public function setNome($nome): void {
            $this->nome = $nome;
        }

        public function setCodice($codice): void {
            $this->codice = $codice;
        }

        public function setTipo($tipo): void {
            $this->tipo = $tipo;
        }

        public function setAmmontare($ammontare): void {
            $this->ammontare = $ammontare;
        }

        public function setBuoniRimanenti($buoniRimanenti): void {
            $this->buoniRimanenti = $buoniRimanenti;
        }

        public function setSpesaMinima($spesaMinima): void {
            $this->spesaMinima = $spesaMinima;
        }

        public function setLimitePerPersona($limitePerPersona): void {
            $this->limitePerPersona = $limitePerPersona;
        }
        
        public function setProdottiInteressati($prodottiInteressati): void {
            $this->prodottiInteressati = $prodottiInteressati;
        }

        public function setProdotto($prodotto): void {
            $this->prodotto = $prodotto;
        }

        public function setCategoria($categoria): void {
            $this->categoria = $categoria;
        }

        public function setDataScadenza($dataScadenza): void {
            $this->dataScadenza = $dataScadenza;
        }
    }